<?php

namespace App\Actions\Fortify;

use App\Mail\WelcomeEmail;
use App\Mail\EmailVerificationOtp;
use App\Models\User;
use App\Models\Settings;
use App\Models\Agent;
use App\Models\CryptoAccount;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Laravel\Fortify\Contracts\CreatesNewUsers;
use Laravel\Jetstream\Jetstream;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Carbon\Carbon;

class CreateNewUser implements CreatesNewUsers
{
    use PasswordValidationRules;

    /**
     * Validate and create a newly registered user.
     *
     * @param  array  $input
     * @return \App\Models\User
     */
    public function create(array $input)
    {
        $settings = Settings::where('id', '1')->first();
        $request = request();
        if ($settings->captcha == "true") {
            Validator::make($input, [
                'name' => ['required', 'string', 'max:255'],
                'username' => ['required', 'unique:users,username'],
                'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
                'password' => $this->passwordRules(),
                'g-recaptcha-response' => 'required|captcha',
                'terms' => Jetstream::hasTermsAndPrivacyPolicyFeature() ? ['required', 'accepted'] : '',
            ])->validate();
        } else {
            Validator::make($input, [
                'name' => ['required', 'string', 'max:255'],
                'username' => ['required', 'unique:users,username'],
                'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
                'password' => $this->passwordRules(),
                'terms' => Jetstream::hasTermsAndPrivacyPolicyFeature() ? ['required', 'accepted'] : '',
            ])->validate();
        }


        if (session('ref_by')) {
            $ref_by = session('ref_by');
            $user = User::where('username', $ref_by)->first();
            $ref_by_id = $user->id;
        } else {
            if (!empty($input['ref_by'])) {
                $sponsor = User::where('username', $input['ref_by'])->first();
                $ref_by_id = $sponsor->id;
            } else {
                $ref_by_id = NULL;
            }
        }

        $user = User::create([
            'name' => $input['name'],
            'email' => $input['email'],
            'currency'=> $input['currency'],
            's_currency' => $input['s_currency'],
            'lastname' => $input['lastname'],
            'middlename'=>$input['middlename'],
            'phone' => $input['phone'],
            'username' => $input['username'],
            'country' => $input['country'],
            'accounttype' => $input['accounttype'],
            'pin'=> $input['pin'],
            'ref_by' => $ref_by_id,
            'status' => 'active',
            'usernumber'=> $this->RandomStringGenerator(10),
            'code1'  => $this->generateSecurityCode(),
            'code2'=>$this->generateSecurityCode(),
            'code3'=>$this->generateSecurityCode(),
            'password' => Hash::make($input['password']),
        ]);

        $cryptoaccnt = new CryptoAccount();
        $cryptoaccnt->user_id = $user->id;
        $cryptoaccnt->save();
        $request->session()->forget('ref_by');

        try {
            Mail::to($user->email)->send(new WelcomeEmail($user));
            \Log::info("Welcome email sent successfully for new user: {$user->name} (ID: {$user->id}) - Email: {$user->email}");
        } catch (\Exception $e) {
            \Log::error("Failed to send welcome email for new user: {$user->name} (ID: {$user->id}) - Email: {$user->email}. Error: " . $e->getMessage());
        }

        // Send OTP for email verification
        $settings = Settings::where('id', 1)->first();
        if ($settings->enable_verification == 'true') {
            // Generate 6-digit OTP
            $otp = str_pad(random_int(0, 999999), 6, '0', STR_PAD_LEFT);

            // Update user with OTP and expiration time (15 minutes)
            $user->update([
                'email_verification_code' => $otp,
                'email_verification_code_expires_at' => Carbon::now()->addMinutes(15)
            ]);

            try {
                // Send OTP email
                Mail::to($user->email)->send(new EmailVerificationOtp($user, $otp));
                \Log::info("Email verification OTP sent successfully for new user: {$user->name} (ID: {$user->id}) - Email: {$user->email}");
            } catch (\Exception $e) {
                \Log::error("Failed to send email verification OTP for new user: {$user->name} (ID: {$user->id}) - Email: {$user->email}. Error: " . $e->getMessage());
            }
        }

        return $user;
    }

    private function generateSecurityCode()
    {
        return strtoupper(bin2hex(random_bytes(3))); // Generates a 6-character alphanumeric code
    }
    function RandomStringGenerator($n)
    {
        $generated_string = "";
        $domain = "12345678900123456789023456789034567890456789056789067890890";
        $len = strlen($domain);
        for ($i = 0; $i < $n; $i++) {
            $index = rand(0, $len - 1);
            $generated_string = $generated_string . $domain[$index];
        }
        // Return the random generated string
        return $generated_string;
    }
}
