<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddTransferLimitsToUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->decimal('min_transfer_limit', 15, 2)->default(1.00)->after('limit');
            $table->decimal('max_transfer_limit', 15, 2)->default(100000.00)->after('min_transfer_limit');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn(['min_transfer_limit', 'max_transfer_limit']);
        });
    }
}
