<?php
if (Auth('admin')->User()->dashboard_style == 'light') {
    $text = 'dark';
    $bg = 'light';
} else {
    $text = 'light';
    $bg = 'dark';
}
?>
@extends('layouts.app')
@section('content')
    @include('admin.topmenu')
    @include('admin.sidebar')
    <div class="main-panel ">
        <div class="content ">
            <div class="page-inner">
                <div class="mt-2 mb-5">
                    <h1 class="title1 d-inline ">Edit {{ $withdrawal->payment_mode }} Record</h1>
                    <div class="d-inline">
                        <div class="float-right btn-group">
                            <a class="btn btn-primary btn-sm" href="{{ route('mwithdrawals') }}"> <i
                                    class="fa fa-arrow-left"></i> back</a>
                        </div>
                    </div>
                </div>
                <x-danger-alert />
                <x-success-alert />
                <div class="mb-5 row">
                    <div class="col-lg-8 offset-lg-2 card p-md-4 p-2 shadow">
                        <div class="mb-3">
                            <form action="{{ route('updatewithdrawal') }}" method="POST">
                                @csrf
                                <input type="hidden" name="id" value="{{ $withdrawal->id }}">

                                <!-- Transaction ID field -->
                                <div class="mb-3 form-group">
                                    <h5 class="">Transaction ID</h5>
                                    <input type="text" class="form-control" name="txn_id" value="{{ $withdrawal->txn_id ?? '' }}">
                                </div>

                                <!-- Amount field -->
                                <div class="mb-3 form-group">
                                    <h5 class="">Amount</h5>
                                    <input type="text" class="form-control" name="amount" value="{{ $withdrawal->amount ?? '' }}">
                                </div>

                                <!-- Date field -->
                                <div class="mb-3 form-group">
                                    <h5 class="">Date</h5>
                                    <input type="datetime-local" class="form-control" name="date" value="{{ $withdrawal->date ? date('Y-m-d\TH:i', strtotime($withdrawal->date)) : '' }}">
                                </div>

                                <!-- Balance field -->
                                <div class="mb-3 form-group">
                                    <h5 class="">Balance</h5>
                                    <input type="text" class="form-control" name="bal" value="{{ $withdrawal->bal ?? '' }}">
                                </div>

                                <!-- Account Name field -->
                                <div class="mb-3 form-group">
                                    <h5 class="">Account Name</h5>
                                    <input type="text" class="form-control" name="accountname" value="{{ $withdrawal->accountname ?? '' }}">
                                </div>

                                <!-- Type field -->
                                <div class="mb-3 form-group">
                                    <h5 class="">Type</h5>
                                    <select class="form-control" name="type">
                                        <option value="Credit" {{ $withdrawal->type == 'Credit' ? 'selected' : '' }}>Credit</option>
                                        <option value="Debit" {{ $withdrawal->type == 'Debit' ? 'selected' : '' }}>Debit</option>
                                    </select>
                                </div>

                                <!-- Account Number field -->
                                <div class="mb-3 form-group">
                                    <h5 class="">Account Number</h5>
                                    <input type="text" class="form-control" name="accountnumber" value="{{ $withdrawal->accountnumber ?? '' }}">
                                </div>

                                <!-- Bank Name field -->
                                <div class="mb-3 form-group">
                                    <h5 class="">Bank Name</h5>
                                    <input type="text" class="form-control" name="bankname" value="{{ $withdrawal->bankname ?? '' }}">
                                </div>

                                <!-- Account Type field -->
                                <div class="mb-3 form-group">
                                    <h5 class="">Account Type</h5>
                                    <input type="text" class="form-control" name="Accounttype" value="{{ $withdrawal->Accounttype ?? '' }}">
                                </div>

                                <!-- Description field -->
                                <div class="mb-3 form-group">
                                    <h5 class="">Description</h5>
                                    <textarea class="form-control" name="Description" rows="3">{{ $withdrawal->Description ?? '' }}</textarea>
                                </div>

                                <!-- Payment Mode field -->
                                <div class="mb-3 form-group">
                                    <h5 class="">Payment Mode</h5>
                                    <select name="payment_mode" class="mb-2 form-control">
                                        <option value="Domestic Transfer" {{ $withdrawal->payment_mode == 'Domestic Transfer' ? 'selected' : '' }}>Domestic Transfer</option>
                                        <option value="International Wire Transfer" {{ $withdrawal->payment_mode == 'International Wire Transfer' ? 'selected' : '' }}>International Wire Transfer</option>
                                        <option value="Cryptocurrency" {{ $withdrawal->payment_mode == 'Cryptocurrency' ? 'selected' : '' }}>Cryptocurrency</option>
                                        <option value="PayPal" {{ $withdrawal->payment_mode == 'PayPal' ? 'selected' : '' }}>PayPal</option>
                                        <option value="Wise Transfer" {{ $withdrawal->payment_mode == 'Wise Transfer' ? 'selected' : '' }}>Wise Transfer</option>
                                        <option value="Skrill" {{ $withdrawal->payment_mode == 'Skrill' ? 'selected' : '' }}>Skrill</option>
                                        <option value="Venmo" {{ $withdrawal->payment_mode == 'Venmo' ? 'selected' : '' }}>Venmo</option>
                                        <option value="Zelle" {{ $withdrawal->payment_mode == 'Zelle' ? 'selected' : '' }}>Zelle</option>
                                        <option value="Cash App" {{ $withdrawal->payment_mode == 'Cash App' ? 'selected' : '' }}>Cash App</option>
                                        <option value="Revolut" {{ $withdrawal->payment_mode == 'Revolut' ? 'selected' : '' }}>Revolut</option>
                                        <option value="Alipay" {{ $withdrawal->payment_mode == 'Alipay' ? 'selected' : '' }}>Alipay</option>
                                        <option value="WeChat Pay" {{ $withdrawal->payment_mode == 'WeChat Pay' ? 'selected' : '' }}>WeChat Pay</option>
                                        <option value="Check Deposit" {{ $withdrawal->payment_mode == 'Check Deposit' ? 'selected' : '' }}>Check Deposit</option>
                                        <option value="Local transfer" {{ $withdrawal->payment_mode == 'Local transfer' ? 'selected' : '' }}>Local transfer</option>
                                        <option value="International transfer" {{ $withdrawal->payment_mode == 'International transfer' ? 'selected' : '' }}>International transfer</option>
                                    </select>
                                </div>
                                
                                <!-- Status field -->
                                <div class="mb-3 form-group">
                                    <h5 class="">Status</h5>
                                    <select name="status" class="mb-2 form-control">
                                        <option value="Pending" {{ $withdrawal->status == 'Pending' ? 'selected' : '' }}>Pending</option>
                                        <option value="Processed" {{ $withdrawal->status == 'Processed' ? 'selected' : '' }}>Processed</option>
                                        <option value="On-hold" {{ $withdrawal->status == 'On-hold' ? 'selected' : '' }}>On-hold</option>
                                        <option value="Rejected" {{ $withdrawal->status == 'Rejected' ? 'selected' : '' }}>Rejected</option>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <button type="submit" class="px-3 btn btn-primary">Update Withdrawal Record</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
