@extends('layouts.dash2')

@section('title', 'Download Banking App')

@section('content')
<div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
    <!-- Header Section -->
    <div class="text-center mb-8">
        <div class="flex justify-center mb-4">
            <div class="bg-primary-100 rounded-full p-4">
                <i data-lucide="smartphone" class="h-12 w-12 text-primary-600"></i>
            </div>
        </div>
        <h1 class="text-3xl font-bold text-gray-900 mb-4">Download Our Banking App</h1>
        <p class="text-lg text-gray-600 max-w-2xl mx-auto">
            Experience secure and convenient banking on the go with our Progressive Web App.
            Access all your banking services offline with enhanced security and performance.
        </p>
    </div>

    <!-- App Features Section -->
    <div class="grid md:grid-cols-3 gap-6 mb-12">
        <div class="bg-white rounded-xl p-6 shadow-sm border border-gray-200 text-center">
            <div class="bg-green-100 rounded-full p-3 w-16 h-16 mx-auto mb-4 flex items-center justify-center">
                <i data-lucide="shield-check" class="h-8 w-8 text-green-600"></i>
            </div>
            <h3 class="text-lg font-semibold text-gray-900 mb-2">Bank-Grade Security</h3>
            <p class="text-gray-600">End-to-end encryption and multi-factor authentication keep your money safe.</p>
        </div>

        <div class="bg-white rounded-xl p-6 shadow-sm border border-gray-200 text-center">
            <div class="bg-blue-100 rounded-full p-3 w-16 h-16 mx-auto mb-4 flex items-center justify-center">
                <i data-lucide="wifi-off" class="h-8 w-8 text-blue-600"></i>
            </div>
            <h3 class="text-lg font-semibold text-gray-900 mb-2">Works Offline</h3>
            <p class="text-gray-600">Access your account balance and transaction history even without internet.</p>
        </div>

        <div class="bg-white rounded-xl p-6 shadow-sm border border-gray-200 text-center">
            <div class="bg-purple-100 rounded-full p-3 w-16 h-16 mx-auto mb-4 flex items-center justify-center">
                <i data-lucide="zap" class="h-8 w-8 text-purple-600"></i>
            </div>
            <h3 class="text-lg font-semibold text-gray-900 mb-2">Lightning Fast</h3>
            <p class="text-gray-600">Instant loading and smooth performance for all your banking needs.</p>
        </div>
    </div>

    <!-- Download Call-to-Action Section -->
    <div class="bg-gradient-to-br from-primary-50 to-secondary-50 rounded-2xl p-8 mb-8">
        <div class="max-w-3xl mx-auto text-center">
            <h2 class="text-2xl font-bold text-gray-900 mb-4">Get Started in Seconds</h2>
            <p class="text-gray-600 mb-8">Click the button below to instantly install our banking app on your device.</p>

            <!-- Main Install Button -->
            <div class="mb-6">
                <button id="main-install-button"
                        class="inline-flex items-center px-8 py-4 bg-gradient-to-r from-primary-600 to-primary-700 hover:from-primary-700 hover:to-primary-800 text-white font-bold text-lg rounded-xl shadow-lg transform transition-all duration-200 hover:scale-105 hover:shadow-xl">
                    <i data-lucide="download" class="h-6 w-6 mr-3"></i>
                    <span id="install-button-text">Install Banking App</span>
                </button>
            </div>

            <!-- Device Detection Info -->
            <div id="device-info" class="text-sm text-gray-500 mb-4">
                <span id="detected-device">Detecting your device...</span>
            </div>

            <!-- Alternative Instructions Toggle -->
            <div class="text-center">
                <button id="show-instructions"
                        class="text-primary-600 hover:text-primary-700 font-medium text-sm underline">
                    Need help? View manual installation steps
                </button>
            </div>
        </div>
    </div>

    <!-- Manual Installation Instructions (Hidden by default) -->
    <div id="manual-instructions" class="bg-gradient-to-br from-gray-50 to-white rounded-2xl p-8 mb-8 hidden">
        <div class="max-w-3xl mx-auto">
            <div class="flex items-center justify-between mb-6">
                <h2 class="text-xl font-bold text-gray-900">Manual Installation Guide</h2>
                <button id="hide-instructions"
                        class="text-gray-500 hover:text-gray-700">
                    <i data-lucide="x" class="h-5 w-5"></i>
                </button>
            </div>

            <!-- Device-specific instructions -->
            <div x-data="{ activeTab: 'android' }" class="space-y-6">
                <!-- Tab Navigation -->
                <div class="flex justify-center space-x-4 mb-6">
                    <button
                        @click="activeTab = 'android'"
                        :class="activeTab === 'android' ? 'bg-primary-600 text-white' : 'bg-white text-gray-700 hover:bg-gray-50'"
                        class="px-6 py-3 rounded-lg font-medium transition-colors flex items-center space-x-2 border border-gray-200">
                        <i data-lucide="smartphone" class="h-5 w-5"></i>
                        <span>Android</span>
                    </button>
                    <button
                        @click="activeTab = 'ios'"
                        :class="activeTab === 'ios' ? 'bg-primary-600 text-white' : 'bg-white text-gray-700 hover:bg-gray-50'"
                        class="px-6 py-3 rounded-lg font-medium transition-colors flex items-center space-x-2 border border-gray-200">
                        <i data-lucide="smartphone" class="h-5 w-5"></i>
                        <span>iOS</span>
                    </button>
                    <button
                        @click="activeTab = 'desktop'"
                        :class="activeTab === 'desktop' ? 'bg-primary-600 text-white' : 'bg-white text-gray-700 hover:bg-gray-50'"
                        class="px-6 py-3 rounded-lg font-medium transition-colors flex items-center space-x-2 border border-gray-200">
                        <i data-lucide="monitor" class="h-5 w-5"></i>
                        <span>Desktop</span>
                    </button>
                </div>

                <!-- Android Instructions -->
                <div x-show="activeTab === 'android'" class="bg-white rounded-xl p-6 shadow-sm">
                    <h3 class="text-lg font-semibold mb-4 flex items-center">
                        <i data-lucide="smartphone" class="h-5 w-5 mr-2 text-green-600"></i>
                        Android Installation
                    </h3>
                    <ol class="space-y-3 text-gray-700">
                        <li class="flex items-start">
                            <span class="bg-primary-100 text-primary-600 rounded-full w-6 h-6 flex items-center justify-center text-sm font-bold mr-3 mt-0.5">1</span>
                            <span>Open Chrome browser and visit this banking website</span>
                        </li>
                        <li class="flex items-start">
                            <span class="bg-primary-100 text-primary-600 rounded-full w-6 h-6 flex items-center justify-center text-sm font-bold mr-3 mt-0.5">2</span>
                            <span>Tap the menu (three dots) in the top-right corner</span>
                        </li>
                        <li class="flex items-start">
                            <span class="bg-primary-100 text-primary-600 rounded-full w-6 h-6 flex items-center justify-center text-sm font-bold mr-3 mt-0.5">3</span>
                            <span>Select "Add to Home screen" or "Install app"</span>
                        </li>
                        <li class="flex items-start">
                            <span class="bg-primary-100 text-primary-600 rounded-full w-6 h-6 flex items-center justify-center text-sm font-bold mr-3 mt-0.5">4</span>
                            <span>Tap "Add" to install the app on your home screen</span>
                        </li>
                    </ol>
                </div>

                <!-- iOS Instructions -->
                <div x-show="activeTab === 'ios'" class="bg-white rounded-xl p-6 shadow-sm">
                    <h3 class="text-lg font-semibold mb-4 flex items-center">
                        <i data-lucide="smartphone" class="h-5 w-5 mr-2 text-blue-600"></i>
                        iOS Installation
                    </h3>
                    <ol class="space-y-3 text-gray-700">
                        <li class="flex items-start">
                            <span class="bg-primary-100 text-primary-600 rounded-full w-6 h-6 flex items-center justify-center text-sm font-bold mr-3 mt-0.5">1</span>
                            <span>Open Safari browser and visit this banking website</span>
                        </li>
                        <li class="flex items-start">
                            <span class="bg-primary-100 text-primary-600 rounded-full w-6 h-6 flex items-center justify-center text-sm font-bold mr-3 mt-0.5">2</span>
                            <span>Tap the Share button (square with arrow pointing up)</span>
                        </li>
                        <li class="flex items-start">
                            <span class="bg-primary-100 text-primary-600 rounded-full w-6 h-6 flex items-center justify-center text-sm font-bold mr-3 mt-0.5">3</span>
                            <span>Scroll down and tap "Add to Home Screen"</span>
                        </li>
                        <li class="flex items-start">
                            <span class="bg-primary-100 text-primary-600 rounded-full w-6 h-6 flex items-center justify-center text-sm font-bold mr-3 mt-0.5">4</span>
                            <span>Tap "Add" to install the app on your home screen</span>
                        </li>
                    </ol>
                </div>

                <!-- Desktop Instructions -->
                <div x-show="activeTab === 'desktop'" class="bg-white rounded-xl p-6 shadow-sm">
                    <h3 class="text-lg font-semibold mb-4 flex items-center">
                        <i data-lucide="monitor" class="h-5 w-5 mr-2 text-purple-600"></i>
                        Desktop Installation
                    </h3>
                    <ol class="space-y-3 text-gray-700">
                        <li class="flex items-start">
                            <span class="bg-primary-100 text-primary-600 rounded-full w-6 h-6 flex items-center justify-center text-sm font-bold mr-3 mt-0.5">1</span>
                            <span>Open Chrome, Edge, or Firefox browser</span>
                        </li>
                        <li class="flex items-start">
                            <span class="bg-primary-100 text-primary-600 rounded-full w-6 h-6 flex items-center justify-center text-sm font-bold mr-3 mt-0.5">2</span>
                            <span>Visit this banking website</span>
                        </li>
                        <li class="flex items-start">
                            <span class="bg-primary-100 text-primary-600 rounded-full w-6 h-6 flex items-center justify-center text-sm font-bold mr-3 mt-0.5">3</span>
                            <span>Look for the "Install" button in the address bar or click the menu</span>
                        </li>
                        <li class="flex items-start">
                            <span class="bg-primary-100 text-primary-600 rounded-full w-6 h-6 flex items-center justify-center text-sm font-bold mr-3 mt-0.5">4</span>
                            <span>Select "Install [App Name]" to add it to your desktop</span>
                        </li>
                    </ol>
                </div>
            </div>
        </div>
    </div>    <!-- PWA Install Prompt -->
    <div id="pwa-install-prompt" class="bg-white rounded-xl p-6 shadow-sm border-2 border-primary-200 mb-8 hidden">
        <div class="flex items-center justify-between">
            <div class="flex items-center">
                <div class="bg-primary-100 rounded-lg p-3 mr-4">
                    <i data-lucide="download" class="h-6 w-6 text-primary-600"></i>
                </div>
                <div>
                    <h3 class="text-lg font-semibold text-gray-900">Install Banking App</h3>
                    <p class="text-gray-600">Get the full app experience with offline access and push notifications.</p>
                </div>
            </div>
            <div class="flex space-x-3">
                <button id="pwa-install-later" class="px-4 py-2 text-gray-600 hover:text-gray-800 font-medium">
                    Later
                </button>
                <button id="pwa-install-button" class="bg-primary-600 hover:bg-primary-700 text-white px-6 py-2 rounded-lg font-medium transition-colors">
                    Install
                </button>
            </div>
        </div>
    </div>

    <!-- App Benefits -->
    <div class="bg-white rounded-xl p-8 shadow-sm border border-gray-200 mb-8">
        <h2 class="text-2xl font-bold text-gray-900 mb-6 text-center">Why Use Our Banking App?</h2>
        <div class="grid md:grid-cols-2 gap-6">
            <div class="space-y-4">
                <div class="flex items-start">
                    <i data-lucide="check-circle" class="h-6 w-6 text-green-500 mr-3 mt-0.5"></i>
                    <div>
                        <h4 class="font-semibold text-gray-900">Instant Access</h4>
                        <p class="text-gray-600">One-tap access from your home screen, no app store required</p>
                    </div>
                </div>
                <div class="flex items-start">
                    <i data-lucide="check-circle" class="h-6 w-6 text-green-500 mr-3 mt-0.5"></i>
                    <div>
                        <h4 class="font-semibold text-gray-900">Always Updated</h4>
                        <p class="text-gray-600">Automatically stays up-to-date with the latest features</p>
                    </div>
                </div>
                <div class="flex items-start">
                    <i data-lucide="check-circle" class="h-6 w-6 text-green-500 mr-3 mt-0.5"></i>
                    <div>
                        <h4 class="font-semibold text-gray-900">Cross-Platform</h4>
                        <p class="text-gray-600">Works seamlessly on all devices and operating systems</p>
                    </div>
                </div>
            </div>
            <div class="space-y-4">
                <div class="flex items-start">
                    <i data-lucide="check-circle" class="h-6 w-6 text-green-500 mr-3 mt-0.5"></i>
                    <div>
                        <h4 class="font-semibold text-gray-900">Lightweight</h4>
                        <p class="text-gray-600">Takes up minimal storage space compared to native apps</p>
                    </div>
                </div>
                <div class="flex items-start">
                    <i data-lucide="check-circle" class="h-6 w-6 text-green-500 mr-3 mt-0.5"></i>
                    <div>
                        <h4 class="font-semibold text-gray-900">Push Notifications</h4>
                        <p class="text-gray-600">Get alerts for transactions, payments, and important updates</p>
                    </div>
                </div>
                <div class="flex items-start">
                    <i data-lucide="check-circle" class="h-6 w-6 text-green-500 mr-3 mt-0.5"></i>
                    <div>
                        <h4 class="font-semibold text-gray-900">Secure by Design</h4>
                        <p class="text-gray-600">Built with modern web security standards and encryption</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Support Section -->
    <div class="bg-gray-50 rounded-xl p-6 text-center">
        <h3 class="text-lg font-semibold text-gray-900 mb-2">Need Help Installing?</h3>
        <p class="text-gray-600 mb-4">Our support team is here to help you get started with the banking app.</p>
        <a href="{{ route('support') }}" class="inline-flex items-center px-6 py-3 bg-primary-600 hover:bg-primary-700 text-white font-medium rounded-lg transition-colors">
            <i data-lucide="help-circle" class="h-5 w-5 mr-2"></i>
            Contact Support
        </a>
    </div>
</div>

<!-- Enhanced PWA Installation Script -->
<script>
let deferredPrompt;
const installPrompt = document.getElementById('pwa-install-prompt');
const installButton = document.getElementById('pwa-install-button');
const laterButton = document.getElementById('pwa-install-later');
const mainInstallButton = document.getElementById('main-install-button');
const installButtonText = document.getElementById('install-button-text');
const deviceInfo = document.getElementById('detected-device');
const showInstructionsBtn = document.getElementById('show-instructions');
const hideInstructionsBtn = document.getElementById('hide-instructions');
const manualInstructions = document.getElementById('manual-instructions');

// Device detection function
function detectDevice() {
    const userAgent = navigator.userAgent.toLowerCase();
    const isAndroid = /android/.test(userAgent);
    const isIOS = /iphone|ipad|ipod/.test(userAgent);
    const isWindows = /windows/.test(userAgent);
    const isMac = /macintosh|mac os x/.test(userAgent);
    const isChrome = /chrome/.test(userAgent);
    const isSafari = /safari/.test(userAgent) && !/chrome/.test(userAgent);
    const isEdge = /edge/.test(userAgent);
    const isFirefox = /firefox/.test(userAgent);

    let device = 'Unknown';
    let canInstall = false;

    if (isAndroid) {
        device = 'Android device';
        canInstall = isChrome;
    } else if (isIOS) {
        device = 'iOS device';
        canInstall = isSafari;
    } else if (isWindows || isMac) {
        device = isWindows ? 'Windows PC' : 'Mac';
        canInstall = isChrome || isEdge || isFirefox;
    }

    return { device, canInstall, isAndroid, isIOS };
}

// Update device info and button text
function updateDeviceInfo() {
    const { device, canInstall, isAndroid, isIOS } = detectDevice();

    if (deviceInfo) {
        if (canInstall) {
            deviceInfo.innerHTML = `✅ <strong>${device}</strong> detected - Ready to install!`;
            deviceInfo.className = 'text-sm text-green-600 mb-4';
        } else {
            deviceInfo.innerHTML = `⚠️ <strong>${device}</strong> detected - Manual installation required`;
            deviceInfo.className = 'text-sm text-orange-600 mb-4';
        }
    }

    if (installButtonText) {
        if (isAndroid) {
            installButtonText.textContent = 'Add to Home Screen';
        } else if (isIOS) {
            installButtonText.textContent = 'Add to Home Screen';
        } else {
            installButtonText.textContent = 'Install Banking App';
        }
    }
}

// Handle main install button click
function handleMainInstallClick() {
    const { canInstall, isIOS } = detectDevice();

    if (deferredPrompt && canInstall) {
        // Use the deferred prompt for supported browsers
        deferredPrompt.prompt();
        deferredPrompt.userChoice.then((choiceResult) => {
            if (choiceResult.outcome === 'accepted') {
                showSuccessMessage('App installation started!');
            }
            deferredPrompt = null;
            updateMainButtonState();
        });
    } else if (isIOS) {
        // For iOS, show specific Safari instructions
        showIOSInstructions();
    } else if (canInstall) {
        // For browsers that support PWA but no prompt was triggered
        showManualInstallation();
    } else {
        // For unsupported browsers, show manual instructions
        showManualInstallation();
    }
}

// Show iOS specific instructions
function showIOSInstructions() {
    const modal = document.createElement('div');
    modal.className = 'fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50 p-4';
    modal.innerHTML = `
        <div class="bg-white rounded-xl p-6 max-w-md w-full">
            <div class="text-center">
                <div class="mb-4">
                    <i data-lucide="smartphone" class="h-12 w-12 text-blue-600 mx-auto"></i>
                </div>
                <h3 class="text-lg font-bold text-gray-900 mb-4">Install on iOS</h3>
                <div class="text-left space-y-3 text-sm text-gray-700 mb-6">
                    <div class="flex items-center">
                        <span class="bg-blue-100 text-blue-600 rounded-full w-6 h-6 flex items-center justify-center text-xs font-bold mr-3">1</span>
                        <span>Tap the Share button <i data-lucide="share" class="h-4 w-4 inline"></i> in Safari</span>
                    </div>
                    <div class="flex items-center">
                        <span class="bg-blue-100 text-blue-600 rounded-full w-6 h-6 flex items-center justify-center text-xs font-bold mr-3">2</span>
                        <span>Scroll down and tap "Add to Home Screen"</span>
                    </div>
                    <div class="flex items-center">
                        <span class="bg-blue-100 text-blue-600 rounded-full w-6 h-6 flex items-center justify-center text-xs font-bold mr-3">3</span>
                        <span>Tap "Add" to install the app</span>
                    </div>
                </div>
                <button onclick="this.closest('.fixed').remove()"
                        class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded-lg font-medium">
                    Got it!
                </button>
            </div>
        </div>
    `;
    document.body.appendChild(modal);
    lucide.createIcons();
}

// Show manual installation section
function showManualInstallation() {
    if (manualInstructions) {
        manualInstructions.classList.remove('hidden');
        manualInstructions.scrollIntoView({ behavior: 'smooth' });
    }
}

// Update main button state
function updateMainButtonState() {
    if (!mainInstallButton) return;

    const { canInstall } = detectDevice();

    if (deferredPrompt && canInstall) {
        mainInstallButton.disabled = false;
        mainInstallButton.className = mainInstallButton.className.replace('opacity-50 cursor-not-allowed', '');
    } else if (canInstall) {
        mainInstallButton.disabled = false;
        installButtonText.textContent = 'Get Installation Help';
    } else {
        mainInstallButton.disabled = false;
        installButtonText.textContent = 'View Install Guide';
    }
}

// Show success message
function showSuccessMessage(message) {
    const successAlert = document.createElement('div');
    successAlert.className = 'fixed top-4 right-4 bg-green-500 text-white px-6 py-3 rounded-lg shadow-lg z-50 transform transition-all duration-300';
    successAlert.innerHTML = `
        <div class="flex items-center">
            <i data-lucide="check-circle" class="h-5 w-5 mr-2"></i>
            <span>${message}</span>
        </div>
    `;
    document.body.appendChild(successAlert);
    lucide.createIcons();

    // Animate in
    setTimeout(() => {
        successAlert.style.transform = 'translateX(0)';
    }, 100);

    // Remove after 4 seconds
    setTimeout(() => {
        successAlert.style.transform = 'translateX(100%)';
        setTimeout(() => {
            if (document.body.contains(successAlert)) {
                document.body.removeChild(successAlert);
            }
        }, 300);
    }, 4000);
}

// Listen for the beforeinstallprompt event
window.addEventListener('beforeinstallprompt', (e) => {
    e.preventDefault();
    deferredPrompt = e;
    updateMainButtonState();

    // Also show the smaller prompt if it exists
    if (installPrompt) {
        installPrompt.classList.remove('hidden');
    }
});

// Event listeners
document.addEventListener('DOMContentLoaded', function() {
    // Initialize device detection
    updateDeviceInfo();
    updateMainButtonState();

    // Main install button
    if (mainInstallButton) {
        mainInstallButton.addEventListener('click', handleMainInstallClick);
    }

    // Original install button (in prompt)
    if (installButton) {
        installButton.addEventListener('click', async () => {
            if (deferredPrompt) {
                deferredPrompt.prompt();
                const { outcome } = await deferredPrompt.userChoice;
                deferredPrompt = null;
                installPrompt?.classList.add('hidden');

                if (outcome === 'accepted') {
                    showSuccessMessage('Banking app installed successfully!');
                }
            }
        });
    }

    // Later button
    if (laterButton) {
        laterButton.addEventListener('click', () => {
            installPrompt?.classList.add('hidden');
        });
    }

    // Show/hide instructions
    if (showInstructionsBtn) {
        showInstructionsBtn.addEventListener('click', () => {
            manualInstructions?.classList.remove('hidden');
            manualInstructions?.scrollIntoView({ behavior: 'smooth' });
        });
    }

    if (hideInstructionsBtn) {
        hideInstructionsBtn.addEventListener('click', () => {
            manualInstructions?.classList.add('hidden');
        });
    }
});

// Listen for app installation
window.addEventListener('appinstalled', () => {
    installPrompt?.classList.add('hidden');
    showSuccessMessage('Banking app installed successfully! Check your home screen.');

    // Update button state
    if (mainInstallButton && installButtonText) {
        installButtonText.textContent = '✅ App Installed';
        mainInstallButton.disabled = true;
        mainInstallButton.className += ' opacity-50 cursor-not-allowed';
    }
});

// Listen for orientation change to re-detect device
window.addEventListener('orientationchange', () => {
    setTimeout(updateDeviceInfo, 500);
});
</script>@endsection
