<?php $__env->startSection('title', $title); ?>
<?php $__env->startSection('content'); ?>
    <!-- Page title -->
    <div class="page-title mb-5">
        <div class="flex justify-between items-center">
            <div class="mb-3">
                <h5 class="text-black text-3xl font-semibold">Your <?php echo e($plan->planDetails->name); ?> Asset</h5>
            </div>
        </div>
    </div>

    <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.danger-alert','data' => []]); ?>
<?php $component->withName('danger-alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
    <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.success-alert','data' => []]); ?>
<?php $component->withName('success-alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>

    <div class="mt-3">
        <div class="bg-white shadow-md rounded-lg p-6">
            <div class="flex justify-between items-center mb-4">
                <p>
                    <?php if($plan->invest_type=="Shares"): ?>
                    <a href="<?php echo e(route('myshares')); ?>" class="inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-primary-600 hover:bg-primary-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary-500">
                        <i class="p-2 rounded-lg lucide-arrow-left-circle text-xl"></i> My Shares Assets

                    </a>
                    <?php else: ?>


                    <?php endif; ?>
                </p>
            </div>

            <h2 class="text-black text-xl font-semibold mb-4">
                <?php echo e($plan->planDetails->name); ?> -
                <?php echo e($plan->planDetails->increment_type == 'Fixed' ? Auth::user()->currency : ''); ?><?php echo e($plan->planDetails->increment_amount); ?>

                <?php echo e($plan->planDetails->increment_type == 'Percentage' ? '%' : ''); ?>

                <?php echo e($plan->planDetails->increment_interval); ?>

                for <?php echo e($plan->planDetails->expiration); ?>

            </h2>

            <div class="flex justify-between items-center">
                <div>
                    <?php if($plan->active == 'yes'): ?>
                        <span class="bg-green-500 text-white text-xs px-2 py-1 rounded-full">Active</span>
                    <?php elseif($plan->active == 'expired'): ?>
                        <span class="bg-red-500 text-white text-xs px-2 py-1 rounded-full">Expired</span>
                    <?php else: ?>
                        <span class="bg-yellow-500 text-white text-xs px-2 py-1 rounded-full">Pending</span>
                    <?php endif; ?>
                </div>
                <?php if($settings->should_cancel_plan): ?>
                    <?php if($plan->active == 'yes'): ?>
                        <a href="#" class="px-3 py-2 bg-red-600 text-white rounded-md hover:bg-red-700 text-sm" data-toggle="modal"
                            data-target="#exampleModal">
                            <i class="fas fa-times"></i> Cancel this Plan
                        </a>

                        <!-- cancel plan modal -->
                        <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog"
                            aria-labelledby="exampleModalLabel" aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="exampleModalLabel">Cancel Plan</h5>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </div>
                                    <div class="modal-body">
                                        Are you sure you want to cancel your <?php echo e($plan->planDetails->name); ?> plan?
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                        <a href="<?php echo e(route('cancelplan', $plan->id)); ?>" class="btn btn-danger">Cancel</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>
            </div>

            <hr class="my-4">

            <div class="mt-5">
                <h4 class="text-xl font-semibold mb-4">Asset Information</h4>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                    <div class="text-center">
                        <h2 class="text-lg font-semibold"><?php echo e(Auth::user()->currency); ?><?php echo e(number_format($plan->amount, 2, '.', ',')); ?></h2>
                        <small>Invested Amount</small>
                    </div>
                    <div class="text-center">
                        <h2 class="text-lg font-semibold text-green-500"><?php echo e(Auth::user()->currency); ?><?php echo e(number_format($plan->profit_earned, 2, '.', ',')); ?></h2>
                        <small>Profit Earned</small>
                    </div>
                    <div class="text-center">
                        <h2 class="text-lg font-semibold text-green-500">
                            <?php if($settings->return_capital): ?>
                                <?php echo e(Auth::user()->currency); ?><?php echo e(number_format($plan->amount + $plan->profit_earned, 2, '.', ',')); ?>

                            <?php else: ?>
                                <?php echo e(Auth::user()->currency); ?><?php echo e(number_format($plan->profit_earned, 2, '.', ',')); ?>

                            <?php endif; ?>
                        </h2>
                        <small>Total Return</small>
                    </div>
                </div>
            </div>

            <div class="mt-5 grid grid-cols-1 md:grid-cols-3 gap-4 border-b pb-4">
                <div>
                    <p class="font-semibold">Duration: <br><strong><?php echo e($plan->planDetails->expiration); ?></strong></p>
                </div>
                <div>
                    <?php if($plan->created_at): ?>
                    <p class="font-semibold">Start Date: <br><strong><?php echo e($plan->created_at->addHour()->toDayDateTimeString()); ?></strong></p>
                    <?php else: ?>
                    N/A
                    <?php endif; ?>
                </div>
                <div>
                    <p class="font-semibold">End Date: <br><strong><?php echo e(\Carbon\Carbon::parse($plan->expire_date)->addHour()->toDayDateTimeString()); ?></strong></p>
                </div>
            </div>

            <div class="mt-5 grid grid-cols-1 md:grid-cols-3 gap-4 border-b pb-4">
                <div>
                    <p class="font-semibold">Minimum Return: <br><strong><?php echo e($plan->planDetails->minr); ?>3%</strong></p>
                </div>
                <div>
                    <p class="font-semibold">Maximum Return: <br><strong><?php echo e($plan->planDetails->maxr); ?>%</strong></p>
                </div>
                <div>
                    <p class="font-semibold">ROI Interval: <br><strong><?php echo e($plan->planDetails->increment_interval); ?></strong></p>
                </div>
            </div>

            <div class="mt-5">
                <h4 class="text-xl font-semibold mb-4">Transactions</h4>
                <div class="overflow-x-auto">
                    <table class="min-w-full table-auto">
                        <thead class="bg-gray-100">
                            <tr>
                                <th class="px-4 py-2 text-left">Type</th>
                                <th class="px-4 py-2 text-left">Date</th>
                                <th class="px-4 py-2 text-left">Amount</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $history): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td class="px-4 py-2">Profit</td>
                                    <td class="px-4 py-2"><?php echo e($history->created_at->addHour()->toDayDateTimeString()); ?></td>
                                    <td class="px-4 py-2"><?php echo e(Auth::user()->currency); ?><?php echo e(number_format($history->amount, 2, '.', ',')); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr class="text-center">
                                    <td colspan="3" class="px-4 py-2">No transaction record yet</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <div class="mt-4">
                    <?php echo e($transactions->links('vendor.pagination.tailwind')); ?>

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dash2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/swizzfx/sefton.swizzfx.pro/resources/views/user/plandetails.blade.php ENDPATH**/ ?>